# Example VNF Charms

## Example VNF Charms

This page is intended to be an index to VNF charms written by members of the OSM community. Please feel free to add links to your own examples below.

### Ansible

Under the scope of a H2020 project, [5GinFIRE](https://5ginfire.eu/) has developed a [charm that enables the configuration of a VNF, instantiated through OSM, using an Ansible playbook](https://github.com/5GinFIRE/mano/tree/master/charms/ansible-charm). The charm builds off of the base vnfproxy and ansible-base layers, and provides a template ready for customization that supports the execution of an Ansible playbook within the Juju framework used by OSM.

### UbuntuVNF 'Say Hello' Proxy Charm

A single VDU VNF containing a simple proxy charm that takes a parameter (name) and sends a greeting to all the VM's terminals using the 'wall' command. It serves like an example that can be extended to send any command with parameters to VNFs. Download it from [here](https://github.com/gianpietro1/osmproxycharms)

### Video Transcoder VNFs

Under the scope of a H2020 project, [5GinFIRE](https://5ginfire.eu/) has developed two Video Transcoding VNFs. The first uses [OpenCV](https://github.com/5GinFIRE/opencv_transcoder_vnf) and the other uses [FFMpeg](https://github.com/5GinFIRE/ffmpeg_transcoder_vnf). Both VNFs use systemd to run the transcoding service. The systemd services are configured using Juju charms. There is also a small script that builds the VNF and NS packages that might be useful.
